#!/c/Perl/bin//perl -w

# $Id: env.pl.in,v 1.2.2.3 2007/04/25 20:20:42 opengl2772 Exp $
# Copyright (C) 2006-2007 Tadamasa Teranishi
#               2006-2007 Namazu Project All rights reserved.
#     This is free software with ABSOLUTELY NO WARRANTY.
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either versions 2, or (at your option)
#  any later version.
#
#  This program is distributed in the hope that it will be useful
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
#  02111-1307, USA
#
#  This file must be encoded in EUC-JP encoding
#
#

#
# print environment
#

use strict;
use English;

eval 'require NKF;';
eval 'require Text::Kakasi;';
eval 'require Text::ChaSen;';
eval 'require MeCab;';

# for filter
eval 'use File::Basename';
eval 'use Archive::Zip';
eval 'use Archive::Tar';
eval 'use MIME::Base64';
eval 'use MIME::QuotedPrint';
eval 'use MP3::Info';
eval 'use OLE::Storage_Lite';

require Cwd;
require 'pltests.pl';

my $cwd = Cwd::cwd();
my $LOG = "$cwd/test-log";

sub env($)
{
    my ($type) = @_;

    if (defined $ENV{$type}) {
        $ENV{$type};
    } else {
        'undef';
    }
}

sub maskenv($)
{
    my ($type) = @_;

    my $mask = env($type);
    
    return $mask if ($mask eq 'undef');

    $mask =~ s/[0-9A-Z]/\*/gi;
    $mask;
}

pltests::putline($LOG, "  *** starting $0");
pltests::putline($LOG, sprintf("OS                : %s", $English::OSNAME));
pltests::putline($LOG, sprintf("Perl              : %f", $English::PERL_VERSION));

my $ver;
eval '$ver = $NKF::VERSION;' or $ver = 'not installed';
pltests::putline($LOG, sprintf("NKF module        : $ver"));
eval '$ver = $Text::Kakasi::VERSION;' or $ver = 'not installed';
pltests::putline($LOG, sprintf("Text::Kakasi      : $ver"));
eval '$ver = $Text::ChaSen::VERSION;' or $ver = 'not installed';
pltests::putline($LOG, sprintf("Text::ChaSen      : $ver"));
eval '$ver = $MeCab::VERSION;' or $ver = 'not installed';
pltests::putline($LOG, sprintf("MeCab module      : $ver"));

eval '$ver = $File::Basename::VERSION;' or $ver = 'not installed';
pltests::putline($LOG, sprintf("File::Basename    : $ver"));
eval '$ver = $Archive::Zip::VERSION;' or $ver = 'not installed';
pltests::putline($LOG, sprintf("Archive::Zip      : $ver"));
eval '$ver = $Archive::Tar::VERSION;' or $ver = 'not installed';
pltests::putline($LOG, sprintf("Archive::Tar      : $ver"));
eval '$ver = $MIME::Base64::VERSION;' or $ver = 'not installed';
pltests::putline($LOG, sprintf("MIME::Base64      : $ver"));
eval '$ver = $MIME::QuotedPrint::VERSION;' or $ver = 'not installed';
pltests::putline($LOG, sprintf("MIME::QuotedPrint : $ver"));
eval '$ver = $MP3::Info::VERSION;' or $ver = 'not installed';
pltests::putline($LOG, sprintf("MP3::Info         : $ver"));
eval '$ver = $OLE::Storage_Lite::VERSION;' or $ver = 'not installed';
pltests::putline($LOG, sprintf("OLE::Storage_Lite : $ver"));

pltests::putline($LOG, sprintf("LANGUAGE          : %s", env('LANGUAGE')));
pltests::putline($LOG, sprintf("LC_ALL            : %s", env('LC_ALL')));
pltests::putline($LOG, sprintf("LC_MESSAGES       : %s", env('LC_MESSAGES')));
pltests::putline($LOG, sprintf("LC_CTYPE          : %s", env('LC_CTYPE')));
pltests::putline($LOG, sprintf("LC_TIME           : %s", env('LC_TIME')));
pltests::putline($LOG, sprintf("LANG              : %s", env('LANG')));
pltests::putline($LOG, sprintf("PATH              : %s", maskenv('PATH')));
pltests::putline($LOG, sprintf("PATHEXT           : %s", env('PATHEXT')));
pltests::putline($LOG, sprintf("HOME              : %s", env('HOME')));
pltests::putline($LOG, sprintf("HOMEDRIVE         : %s", env('HOMEDRIVE')));
pltests::putline($LOG, sprintf("HOMEPATH          : %s", maskenv('HOMEPATH')));
pltests::putline($LOG, sprintf("TZ                : %s", env('TZ')));
pltests::putline($LOG, sprintf("SHELL             : %s", env('SHELL')));
pltests::putline($LOG, sprintf("ComSpec           : %s", env('ComSpec')));
pltests::putline($LOG, sprintf("SystemDrive       : %s", env('SystemDrive')));
pltests::putline($LOG, sprintf("TEMP              : %s", env('TEMP')));
pltests::putline($LOG, sprintf("TMP               : %s", env('TMP')));
pltests::putline($LOG, sprintf("USER              : %s", env('USER')));
pltests::putline($LOG, sprintf("USERNAME          : %s", env('USERNAME')));
pltests::putline($LOG, sprintf("USERPROFILE       : %s", env('USERPROFILE')));
pltests::putline($LOG, sprintf("NAMAZURC          : %s", env('NAMAZURC')));
pltests::putline($LOG, sprintf("MKNMZRC           : %s", env('MKNMZRC')));
pltests::putline($LOG, sprintf("NAMAZULOCALEDIR   : %s", env('NAMAZULOCALEDIR')));
pltests::putline($LOG, sprintf("KANWADICTPATH     : %s", env('KANWADICTPATH')));
pltests::putline($LOG, sprintf("ITAIJIDICTPATH    : %s", env('ITAIJIDICTPATH')));
pltests::putline($LOG, sprintf("MECABRC           : %s", env('MECABRC')));
pltests::putline($LOG, sprintf("pkgdatadir        : %s", env('pkgdatadir')));
pltests::putline($LOG, sprintf("HTTP_proxy        : %s", env('HTTP_proxy')));
pltests::putline($LOG, sprintf("HTTP_proxy_user   : %s", maskenv('HTTP_proxy_user')));
pltests::putline($LOG, sprintf("HTTP_proxy_pass   : %s", maskenv('HTTP_proxy_pass')));

exit 0;
